;; This example shows how to perform a directory of a disc
;; and extract the filenames. 
;;
;; This code is public domain and can freely be used in your
;; own programs.
;;
;; Written by Kevin Thacker. 2002



;;------------------------------------------------------------------

;; firmware function to catalog a disc or cassette
.cas_catalog equ &bc9b
;; firmware function to disable text output
.txt_vdu_enable equ &bb54
;; firmware function to enable text output
.txt_vdu_disable equ &bb57
;; firmware function to output a character to the screen
.txt_output equ &bb5a
;; firmware function to find a RSX 
.kl_find_command equ &bcd4

;;------------------------------------------------------------------

org &8000
nolist


;;------------------------------------------------------------------
;; find BIOS SET MESSAGE command
;; this is used to disable disc messages.
;; this is compatible with other DOSs that also provide this command

ld hl,cmd_bios_set_message
call kl_find_command
ret nc							;; if carry flag is clear, then command has not been found

;; command found

;; store address of command
ld (bios_set_message),hl
ld a,c
;; store "rom select" of command
ld (bios_set_message+2),a

;;------------------------------------------------------------------

;; do CAT
call fetch_directory

;; display files
call display_directory
ret


;;------------------------------------------------------------------
;; display files from data generated by CAS CATALOG function

.display_directory

ld hl,two_k_buffer

.dd
;; if marker is not &ff, then end of filename listing found
;; otherwise continue
ld a,(hl)
cp &ff
ret nz
inc hl

;; display name part of filename
ld b,8
.dd2
ld a,(hl)
and &7f
inc hl
call txt_output
djnz dd2

;; display seperation dot
ld a,"."
call txt_output

;; display extension part of filename
ld b,3
.dd3
ld a,(hl)
and &7f
inc hl
call txt_output
djnz dd3

;; skip file size in K
inc hl
inc hl

;; new line
ld a,10
call txt_output
ld a,13
call txt_output

jp dd


;;------------------------------------------------------------------
;; perform a CAT command

.fetch_directory
;; disable disc messages. Error messages will not be displayed.
ld a,&ff
rst 3						;; KL FAR CALL
defw bios_set_message

;; disable text output
call txt_vdu_disable

ld de,two_k_buffer

;; initialise in case of an error
xor a
ld (de),a

;; do catalog
call cas_catalog

;; enable text output
call txt_vdu_enable

;; enable disc messages. Error messages will be displayed
ld a,0
rst 3						;; KL FAR CALL
defw bios_set_message
ret


;;------------------------------------------------------------------

;; this is initialised when the "BIOS SET MESSAGE" RSX has been found.
.bios_set_message
defw 0                    ;; address of function
defb 0                    ;; "rom select" for function


.cmd_bios_set_message
defb 1+&80				;; this is the "BIOS SET MESSAGE" RSX

;;------------------------------------------------------------------

;; used by CAS CATALOG function to store list of files in directory
.two_k_buffer equ $